# Bagaar ACL

## Description 

A package to facilitate role and permission management.

## Installation

- Add following repository to composer.json:
 ```
 "repositories": [
     {
         "type": "vcs",
         "url": "git@git.bagaar.be:shelf/bagaar-acl.git"
     }
 ]
 ```

- Run `composer require bagaar/bagaar-acl`

- Add `Bagaar\Acl\Providers\BagaarAclProvider::class` to the array of providers in config/app.php
 
- Run `php artisan vendor:publish`
 
- In config/bagaaracl.php set the user key to your User model and some default roles:
```
return [

    'user' => App\User::class,

    'defaults' => [
        'administrators' => 'Administrators',
        'users' => 'Users'
    ]
    
];

```

- Now import the HasRoles trait in your User model:

```
<?php

namespace App;

use Bagaar\Acl\HasRoles;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use Notifiable, HasRoles;

```

- You can run `php artisan bagaar:acl:defaults` to create the roles specified in the config file.
