<?php

namespace Bagaar\Acl\Providers;

use Bagaar\Acl\Permission;
use Illuminate\Support\ServiceProvider;

class BagaarAclProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                \Bagaar\Acl\Commands\BagaarAclDefaults::class
            ]);
        }
        foreach ($this->getPermissions() as $permission) {
            \Gate::define($permission->slug, function ($user) use ($permission) {
                return $user->hasPermission($permission);
            });
        }
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->publishes([
            __DIR__.'/../config/bagaaracl.php' => config_path('bagaaracl.php'),
        ]);
        $this->loadMigrationsFrom(__DIR__.'/../migrations');
    }

    protected function getPermissions()
    {
        return Permission::with('roles')->get();
    }
}
