<?php

namespace Bagaar\Acl\Middleware;

use Closure;

class CheckRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, $role)
    {
        if (! auth()->user()->hasRole($role)) {
            abort(403);
        }

        return $next($request);
    }
}
