# Bagaar ACL

## Description 

A package to facilitate role and permission management.

## Installation

- Add following repository to composer.json:

 ```php
 "repositories": [
     {
         "type": "vcs",
         "url": "git@git.bagaar.be:shelf/bagaar-acl.git"
     }
 ]
 ```

- Run `composer require bagaar/bagaar-acl`

- Add `Bagaar\Acl\Providers\BagaarAclServiceProvider::class` to the array of providers in config/app.php:

```php
'providers' => [
        ...
        /*
         * Package Service Providers...
         */
        Bagaar\Acl\Providers\BagaarAclServiceProvider::class,
```
 
- Run `php artisan vendor:publish --provider="Bagaar\Acl\Providers\BagaarAclServiceProvider"`
 
- In config/bagaaracl.php set the user key to your User model and some default roles:

```php
return [
    'user' => App\User::class,

    'defaults' => [
        'administrators' => 'Administrators',
        'users' => 'Users'
    ]
    
];
```

- Now import the HasRoles trait in your User model:

```php
use Bagaar\Acl\HasRoles;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use Notifiable, HasRoles;
```

- Run `php artisan migrate`
- You can run `php artisan bagaar:acl:defaults` to create the roles specified in the config file.
* In `app\Http\Kernel.php` add the middleware to the $routeMiddleware array:
```php
protected $routeMiddleware = [
            //
            'role' => \Bagaar\Acl\Middleware\CheckRole::class
];
```
Now you can protect your routes like so:
```php
Route::group(['middleware' => 'role:administrators'], function(){
    // routes
});
```
Where the parameter of the middleware is the name of the role you want to give access to.