<?php

namespace Bagaar\Acl\Commands;

use Bagaar\Acl\Models\Role;
use Illuminate\Console\Command;

class BagaarAclAddRole extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bagaar:acl:addrole';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create a new role';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $name = $this->ask('What is the name of the role?');
        $slug = $this->ask('What is the slug for the role?');
        Role::create(['name' => $name, 'slug' => $slug]);
    }
}
