<?php

namespace Bagaar\Acl\Commands;

use Illuminate\Console\Command;

class BagaarAclDefaults extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bagaar:acl:defaults';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Set some default roles';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $roles = config('bagaaracl.defaults');
        foreach ($roles as $slug => $name) {
            \Bagaar\Acl\Models\Role::create(['name' => $name, 'slug' => $slug]);
        }
    }
}
