<?php

namespace Bagaar\Acl\Providers;

use Bagaar\Acl\Models\Permission;
use Illuminate\Support\ServiceProvider;

class BagaarAclServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                \Bagaar\Acl\Commands\BagaarAclDefaults::class
            ]);
        } else {
            foreach ($this->getPermissions() as $permission) {
                \Gate::define($permission->slug, function ($user) use ($permission) {
                    return $user->hasPermission($permission);
                });
            }
        }
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->publishes([
            __DIR__.'/../config/bagaar_acl.php' => config_path('bagaaracl.php'),
            __DIR__.'/../migrations/2016_10_18_012942_create_bagaar_roles_tables.php' => database_path('migrations/2016_10_18_012942_create_bagaar_roles_tables.php'),
            __DIR__.'/../migrations/2017_06_21_091513_add_description_to_permissions.php' => database_path('migrations/2017_06_21_091513_add_description_to_permissions.php')
        ]);
    }

    protected function getPermissions()
    {
        return Permission::with('roles')->get();
    }
}
