@foreach($resources as $resource)
## {{$resource['name']}}

### Properties
|Name|Type|Description|
|------|------|------|
@foreach($resource['attributes'] as $attribute)
|{{$attribute['name']}}|{{implode(', ', $attribute['type'])}}|{{$attribute['description']}}|
@endforeach

### Relations

|Slug|Name|Type|
|------|------|------|
@foreach($resource['relations'] as $attribute)
|{{$attribute['slug']}}|{{$attribute['model']}}|{{$attribute['type']}}|
@endforeach

@if(count($resource['relations']) > 0)
<relations model="{{$resource['name']}}" :relations="{!! str_replace('"', "'", json_encode($resource['relations'])) !!}"></relations>
@endif
@endforeach