# Endpoints
@foreach($endpoints as $base => $description)
## {{$base}}

{!! nl2br($description['description']) !!}

@if(count($description['relations']) > 0)
### Relations

<Relations model="{{$description['model']}}" :relations="{!! str_replace('"', "'", json_encode($description['relations'])) !!}"></Relations>
@endif

@foreach($description['endpoints'] as $endpoint)
### {{$endpoint['method']}} {{$endpoint['uri']}}

{{$endpoint['description']}}

@if(is_array($endpoint['filters']))
<Filters :filters="{!! str_replace('"', "'", json_encode($endpoint['filters'])) !!}"></Filters>
@endif

@if(is_array($endpoint['rules']))
#### Rules
<Rules :fields="{!! str_replace('"', "'", json_encode($endpoint['rules'])) !!}"></Rules>
@endif

@if(is_array($endpoint['attributes']))
#### Request
```json
{!! json_encode($endpoint['attributes'], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES) !!}
```
@endif

@if(is_array($endpoint['response']))
#### Response
```json
{!! json_encode($endpoint['response'], JSON_PRETTY_PRINT) !!}
```
@endif
@endforeach
@endforeach