<?php

namespace Bagaar\Documentation\Installer;

use Illuminate\Console\Command;

class Config
{
    public $config = [];
    protected $basePath;
    protected $configPath;

    /**
     * Config constructor.
     *
     * @param null $basePath
     */
    public function __construct($basePath = null)
    {
        $this->basePath = $basePath ?? resource_path('docs');
        $this->configPath = $this->basePath . '/.vuepress/config.js';

        $this->initConfig();
    }

    /**
     * Tweak VuePress config.
     *
     * @param $path
     * @param $value
     */
    public function setConfig($path, $value)
    {
        array_set($this->config, $path, $value);
    }

    public function store(Command $output)
    {
        $content = 'module.exports = ' . json_encode($this->config, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

        file_put_contents($this->configPath, $content);
    }

    protected function initConfig()
    {
        if(file_exists($this->configPath))
        {
            $configContents = file_get_contents($this->configPath);

            $this->config = json_decode(trim(str_replace('module.exports = ', '', $configContents)), true);
            return;
        }
        $this->config = [
            'title'         => config('documentation.title', env('APP_NAME') . ' API documentation'),
            'description'   => config('documentation.description', env('APP_NAME') . ' API documentation'),
            'base'          => config('documentation.url_path'),
            'serviceWorker' => true,
            'evergreen'     => true,
            'themeConfig'   => [
                'nav'                  => [
                    [
                        'text' => 'Home',
                        'link' => '/',
                    ],
                    [
                        'text' => 'Endpoints',
                        'link' => 'endpoints',
                    ],
                    [
                        'text' => 'Resources',
                        'link' => 'resources',
                    ]
                ],
                'sidebar'              => 'auto',
                'displayAllHeaders'    => true,
                'search'               => true,
                'searchMaxSuggestions' => 10,
                'lastUpdated'          => 'Last updated',
            ],
        ];
    }
}