<?php

namespace Bagaar\Documentation\Commands;

use Bagaar\Documentation\Facades\Documentation;
use Bagaar\Documentation\Installer\Config;
use Illuminate\Console\Command;
use Illuminate\Routing\Router;
use Symfony\Component\Console\Helper\ProgressBar;
use Symfony\Component\Console\Input\ArrayInput;

class GenerateAlgoliaCrawlerConfig extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:algolia-crawler';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generates a json file that you can use to run the Algolia crawler.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @throws \Throwable
     * @return mixed
     */
    public function handle()
    {
        $json = [
            'index_name' => str_slug(env('APP_NAME')),
            'start_urls' => [
                config('documentation.url_base') . config('documentation.url_path')
            ],
            'selectors'  => [
                "lvl0" => "h1",
                "lvl1" => "h2",
                "lvl2" => "h3",
                "lvl3" => "h4",
                "lvl4" => "h5",
                "text" => "p, li, pre, td",
            ],
        ];

        $filePath = resource_path('docs/.vuepress/crawler.json');
        file_put_contents($filePath, json_encode($json, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));

        $this->info('[+] Created crawler config at ' . $filePath);
    }
}
