<?php

namespace Bagaar\Documentation\Generator;


use Barryvdh\Reflection\DocBlock;
use Closure;
use Illuminate\Routing\Route;
use Symfony\Component\Console\Helper\ProgressBar;

class Routes
{
    public function parse($routes, ProgressBar $progress)
    {
        return collect($routes)->map(function (Route $route) use ($progress) {
            $uri = $route->uri();

            $uriSplit = explode('/', $uri);

            $group = $uriSplit[0];
            $entry = $uriSplit[1] ?? null;
            $identifier = $uriSplit[2] ?? null;

            if (!starts_with($identifier, '{')) {
                $identifier = null;
            }

            $action = ltrim($route->getActionName(), '\\');

            if ($action != 'Closure') {
                list($controller, $method) = explode('@', $action);
            }

            $data = [
                'host'       => $route->domain(),
                'method'     => implode('|', $route->methods()),
                'uri'        => [
                    'path'       => $uri,
                    'group'      => $group,
                    'entry'      => $entry,
                    'identifier' => $identifier,
                ],
                'name'       => $route->getName(),
                'action'     => $action,
                'controller' => [
                    'class'  => $controller ?? null,
                    'method' => $method ?? null,
                ],
                'middleware' => collect($route->gatherMiddleware())
                    ->map(function ($middleware) {
                        return $middleware instanceof Closure ? 'Closure' : $middleware;
                    })
                    ->filter(function ($middleware) {
                        return $middleware != 'Closure';
                    })
                    ->implode(','),
            ];

            $progress->advance();

            return $data;
        })
            // Only include api and oauth routes
            ->filter(function ($route) {
                return in_array($route['uri']['group'], ['api', /*'oauth'*/]) && $route['action'] != 'Closure';
            })
            // Group them by endpoints
            ->groupBy(function ($route) {
                return $route['uri']['group'] . '/' . $route['uri']['entry'];
            })
            ->all();
    }
}