# Bagaaravel API documentation generator

This package can be installed into any Bagaaravel API to generate documentation.

## Installation

Via Composer & Yarn

``` bash
$ composer require bagaar/bagaaravel-documentation-generator
$ php artisan vendor:publish --provider="Bagaar\Documentation\DocumentationServiceProvider"
$ php artisan documentation:install
$ yarn install
```

*Note* Use Yarn instead of NPM, NPM fails to generate the correct dependency tree.

### Update .gitlab-ci.yml
In order to deploy the documentation add this to your repo's `.gitlab-ci.yml`

```yaml
stages:
- deploy-docs

pages:
    image: alpine:latest
    tags:
    - docker-ci
    script:
    - mv resources/docs/.vuepress/dist public
    stage: deploy-docs
    artifacts:
        paths:
        - public
```

## Configuration
This package comes bundled with a config that allows you to set a few [VuePress](https://vuepress.vuejs.org) related settings;

| Key | Description |
|-----|----|
|title| The title of the app (defaults to `APP_NAME`).|
|description|An intro that's added on the front-page.|
|url_base|The base url of where the documentation will be hosted (defaults to `app.url` config, can be set through `DOCS_URL_BASE`). Needs to start and end with a `/`. (use the name of the repository)|
|url_path|The path from where the docs will be served (can be set through `DOCS_URL_PATH`). Used for Algolia. (`project`.bagaar.io)|

## Commands

### Generate documentation

To generate documentation based on your code base run these commands.

```bash
$ php artisan gen:documentation
$ yarn docs:dev
```
**Note** You can also run `php artisan gen:documentation --models` if you want to run `ide-helper:models` before the documentation gets generated.


The command will present you with an url you can use to check the final result,
if everything looks ok, you can build your docs for [deployment](https://vuepress.vuejs.org/guide/deploy.html)

```bash
$ yarn docs:build
```

This will build the docs and place the files into `resources/docs/.vuepress/dist`.

### Add custom documentation pages
In Some cases you might want to add your documentation pages next to the ones that are generated.

```bash
$ php artisan make:documentation "Title of your page"
```

This will generate a file for you in `resources/docs/` and register a link to it in `resources/docs/.vuepress/config.js`.

### Generate crawler.json for Algolia

In case you select Algolia to provide search results, you can easily generate a json config file that describes what/how the crawler should index data.

```bash
$ php artisan make:algolia-crawler
```

## Usage

### Models

Be sure to document your models, this can be done automatically with `barryvdh/laravel-ide-helper`, that's included as a dev-dependency.

```bash
$ php artisan ide-helper:models --write
```

This will add some doc-blocks to all your models that can be used as a reference.

```php
/**
 * @property int $id
 * @property string $name Some custom description I added afterwards.
 * @property string $email
 * @property string $password
 * @property string|null $remember_token
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 */
```

### Transformers

The same doc-block syntax should be added to the transform method in your transformers. You are able to use dot-syntax here.

If this isn't done, the model's attributes will be returned, if defined, otherwise an empty payload will be presented.


### Controllers

#### Adding descriptions
Description can be added to a controller to describe all the connected endpoints(methods) generally.

Next to that you can add a description to a method to go a little bit deeper on a single endpoint.

```php
/**
 * Handles the User resource (added as info above all this resource's endpoints)
 */
class UserController extends JsonApiController
{
    public static $model = 'User';

    /**
     * Disables a user account (added as a specific description for this endpoint)
     */
    public function disable($id)
    {
        // Implementation
    }
}
```

#### Custom methods / transformers

When custom endpoints are added to your controller, or you decide to use a non-standard transformer in a standard controller method.

You should define an `@transformer` dockblock, if this does not happen the standard transformer will be loaded that's used by the normal controller methods.

Next to that you can add property tags to your custom controller method to describe the payload that's expected to be sent (only on `POST|PUT|PATCH` requests).
```php
class UserController extends JsonApiController
{
    public static $model = 'User';

    /**
     * When creating a user we want to use a different transformer than the general UserTransformer.
     *
     * @param FormRequestInterface $request
     * @transformer UserCreateTransformer
     *
     * @return mixed
     */
    public function store(FormRequestInterface $request)
    {
        $this->responder = (new JsonApiResponder())->setTransformer(UserCreateTransformer);
        return parent::store($request);
    }
    
    /**
     * Disables a user account (no transformer used)
     * @tranformer null
     */
    public function disable($id)
    {
        // Implementation
        $this->responder->noContent();
    }
    
    /**
     * Disables a user account
     *
     * @tranformer SomeOtherTransformer
     *
     * @return mixed
     */
    public function doSomethingElse($id)
    {
        // Implementation
        
        // Respond
        $this->responder = (new JsonApiResponder())->setTransformer(SomeOtherTransformer);
        return $this->responder->transformAndRespondItem($item);
    }

    /**
     * Change the user's read_toc field.
     *
     * @param Request    $request
     * @param integer    $id
     *
     * @property boolean $read Property gets translated to data.attributes.read
     * @transformer null
     */
    public function readTOC(Request $request, $id)
    {
        // Implementation
    }
}
```


## Search
Vuepress comes with a simple search out-of-the-box that only scans header elements,
if you want a more specific search you should consider creating an [Algolia](https://www.algolia.com/pricing) account.

Algolia provides a docker image that can index the documentation ([Documentation](https://community.algolia.com/docsearch/run-your-own.html)).

Once you have the docker setup pulled in and built, you'll need to create 2 config files, afterwards you can simply run:

```bash
$ ./docsearch docker:run ./config.json
```

### .env
This file contains the credentials to Algolia, along with other keys you can set for reporting.
The important ones are:

```bash
APPLICATION_ID=XXXX
API_KEY=XXXXXXXXXXXXXXXXXXXXXX
MONITORING_API_KEY=XXXXXXXXXXXXXXXXXXXXXX
```

### config.json
This file describes the way the documentation site will be crawled:

```json
{
    "index_name": "", // The name the search key-value pairs will be stored under (should be unique per site)
    "start_urls": [
        "" // The entry page(s) of the documentation
    ],
    "stop_urls": [],
    // Which HTML tags to index, by importance
    "selectors": {
        "lvl0": "h1",
        "lvl1": "h2",
        "lvl2": "h3",
        "lvl3": "h4",
        "lvl4": "h5, th",
        "text": "p, li, pre, td"
    }
}
```

## Change log

Please see the [changelog](changelog.md) for more information on what has changed recently.

## Testing

TODO

## Credits

- [All Contributors][link-contributors]

## License

license. Please see the [license file](license.md) for more information.

[link-contributors]: ../../contributors]