<?php

namespace Bagaar\Documentation;

use Bagaar\Documentation\Commands\CreateCustomDocumentationPage;
use Bagaar\Documentation\Commands\GenerateAlgoliaCrawlerConfig;
use Bagaar\Documentation\Commands\GenerateDocumentation;
use Bagaar\Documentation\Commands\InstallDocumentationGenerator;
use Illuminate\Support\ServiceProvider;

class DocumentationServiceProvider extends ServiceProvider
{
    /**
     * Perform post-registration booting of services.
     *
     * @return void
     */
    public function boot()
    {
        // $this->loadTranslationsFrom(__DIR__.'/../resources/lang', 'bagaar');
        // $this->loadViewsFrom(__DIR__.'/../resources/views', 'bagaar');
        // $this->loadMigrationsFrom(__DIR__.'/../database/migrations');
        // $this->loadRoutesFrom(__DIR__.'/routes.php');

        // Publishing is only necessary when using the CLI.
        if ($this->app->runningInConsole()) {
            // Register all available commands
            $this->commands([
                CreateCustomDocumentationPage::class,
                GenerateAlgoliaCrawlerConfig::class,
                GenerateDocumentation::class,
                InstallDocumentationGenerator::class
            ]);

            // Publishing the configuration file.
            $this->publishes([
                __DIR__.'/../config/documentation.php' => config_path('documentation.php'),
                __DIR__.'/../config/ide-helper.php' => config_path('ide-helper.php'),
            ], 'documentation.config');

            // Publishing the views.
            $this->publishes([
                __DIR__.'/../resources/views' => base_path('resources/views/vendor/bagaar'),
            ], 'documentation.views');
            $this->loadViewsFrom(__DIR__.'/../resources/views', 'documentation');

            // Publishing assets.
            /*$this->publishes([
                __DIR__.'/../resources/assets' => public_path('vendor/bagaar'),
            ], 'documentation.views');*/

            // Publishing the translation files.
            /*$this->publishes([
                __DIR__.'/../resources/lang' => resource_path('lang/vendor/bagaar'),
            ], 'documentation.views');*/
        }
    }

    /**
     * Register any package services.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(__DIR__.'/../config/documentation.php', 'documentation');

        // Register the service the package provides.
        $this->app->singleton('documentation', function ($app) {
            return new Documentation;
        });
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['documentation'];
    }
}