<?php

namespace Bagaar\Documentation;

class Documentation
{
    /**
     * Returns an initiated generator class based on the provided type.
     *
     * @param string $type
     *
     * @return mixed
     */
    public function generator($type)
    {
        $class = 'Bagaar\Documentation\Generator\\' . ucfirst($type);

        return new $class;
    }

    /**
     * Returns an initiated installer class.
     *
     * @param      $type
     * @param null $basePath
     *
     * @return mixed
     */
    public function installer($type, $basePath = null)
    {
        $class = 'Bagaar\Documentation\Installer\\' . ucfirst($type);

        return new $class($basePath);
    }
}