<?php

namespace Bagaar\Documentation\Installer;

use Illuminate\Console\Command;

class Components
{
    public $components = ['Filters', 'RelationGraph', 'Relations', 'RelationModal', 'Rules'];

    protected $basePath;

    public function __construct($basePath=null)
    {
        $this->basePath = $basePath ?? resource_path('docs');
    }

    public function store(Command $output)
    {
        $files = [];

        foreach($this->components as $name)
        {
            $files[] = $name . '.vue';
        }

        $files[] = 'ConnectRelation.mixin.js';
        $files[] = 'nomnoml.js';

        foreach($files as $name)
        {
            $path = __DIR__.'/../../resources/components';
            $filePath = $path.'/'.$name;

            if(file_exists($filePath))
            {
                file_put_contents($this->basePath . '/.vuepress/components/'.$name, file_get_contents($filePath));

                $output->info('    Installed ' . $name);
                continue;
            }
            $output->warn('    [-] Failed to install ' . $name);
        }
    }
}