<?php

namespace Bagaar\Documentation\Commands;

use Bagaar\Documentation\Facades\Documentation;
use Bagaar\Documentation\Installer\Config;
use Illuminate\Console\Command;
use Illuminate\Routing\Router;
use Symfony\Component\Console\Helper\ProgressBar;
use Symfony\Component\Console\Input\ArrayInput;

class CreateCustomDocumentationPage extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:documentation {title}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Creates a custom documentation page and links it.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @throws \Throwable
     * @return mixed
     */
    public function handle()
    {
        $docsDir = resource_path('docs');
        $docName = $this->argument('title');
        $docFileName = str_slug($docName) . '.md';

        if(file_exists($docsDir . '/' . $docFileName))
        {
            $this->error('Seems like there\'s already a documentation file with that same name present.');
            return;
        }

        $path = $docsDir . '/' . $docFileName;
        // Create the file
        file_put_contents($path, '# '.$docName);
        $this->info('[+] Created file: ' . $path);

        // Register link
        /**
         * @var $config Config
         */
        $config = Documentation::installer('config');

        $newIndex = count($config->config['themeConfig']['nav']);
        $linkPath = 'themeConfig.nav.'.$newIndex;
        $config->setConfig(
            $linkPath,
            [
                'text' => $docName,
                'link' => str_replace('.md', '', $docFileName),
            ]
        );
        $config->store($this);
        $this->info('[+] Registered link under ' . $linkPath);
    }
}
