<?php namespace Bagaaravel\Api;

class JsonApiResponse
{
    protected $headers = [];
    protected $meta    = [];
    protected $links   = [];
    protected $data    = [];

    public function __construct()
    {
        $this->headers = [
            'Content-Type' => 'application/vnd.api+json',
        ];
    }

    public function addMeta($meta)
    {
        $this->meta = array_merge($this->meta, $meta);
        return $this;
    }

    public function addLinks($links)
    {
        $this->links = array_merge($this->links, $links);
        return $this;
    }

    public function setData($data)
    {
        $this->data = $data;
        return $this;
    }

    public function output()
    {
        $response = [
            'data' => $this->data,
        ];

        if ($this->meta != []) {
            $response['meta'] = $this->meta;
        }

        if ($this->links != []) {
            $response['links'] = $this->links;
        }

        return $response;
    }
}
