<?php namespace Bagaaravel\Middleware;

use Authorizer;
use Bagaaravel\Exceptions\ApiException;
use Closure;
use Illuminate\Http\Response;
use Sentinel;

class AuthorizationMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $roles = null)
    {
        if (!$roles) {
            // not correctly defined so skip the middleware
            return $next($request);
        }

        $allowed_roles = explode('+', $roles);
        $user_id       = Authorizer::getResourceOwnerId();
        $user          = Sentinel::findById($user_id);
        if (!$user->roles || count(array_intersect($user->roles->pluck('slug')->all(), $allowed_roles)) == 0) {
            throw new ApiException('UNAUTHORIZED', Response::HTTP_UNAUTHORIZED);
        }

        return $next($request);
    }
}
