<?php

namespace Bagaaravel\Models;

use Cartalyst\Sentinel\Laravel\Facades\Sentinel;
use Cartalyst\Sentinel\Users\EloquentUser;
use Facebook\Facebook;
use Webpatser\Uuid\Uuid;

class User extends EloquentUser
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'email',
        'password',
        'last_login',
        'permissions',
        'oauth_data',
        'oauth_service',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    public function authenticate($username, $password)
    {
        $social_oauth_providers = ['facebook'];
        if (!in_array($username, $social_oauth_providers)) {
            $user = Sentinel::stateless([
                'email'    => $username,
                'password' => $password,
            ]);
        } else {
            switch ($username) {
                case 'facebook':
                    $user = $this->findOrCreateWithFacebook($password);
                    break;
            }
        }
        if ($user) {
            return $user->id;
        }
        return false;
    }

    public function findOrCreateWithFacebook($token)
    {
        $fb = new Facebook([
            'app_id'                => env('FACEBOOK_APP_ID'),
            'app_secret'            => env('FACEBOOK_APP_SECRET'),
            'default_graph_version' => 'v2.5',
        ]);
        $response = $fb->get('me?fields=id,first_name,last_name,email', $token);
        $graph    = $response->getGraphUser();

        $user = Sentinel::findByCredentials([
            'email' => $graph['email'],
        ]);
        if (!$user) {
            $user = Sentinel::registerAndActivate([
                'email'    => $graph['email'],
                'password' => Uuid::generate(3, $token, Uuid::NS_DNS), // we don't care about the password
            ]);
        }
        $user->update([
            'first_name'    => $graph['first_name'],
            'last_name'     => $graph['last_name'],
            'oauth_service' => 'facebook',
            'oauth_data'    => $token,
        ]);
        return $user;
    }
}
