<?php namespace Bagaaravel\Api;

use Illuminate\Routing\Controller as BaseController;

abstract class JsonApiController extends BaseController
{
    use JsonApiTrait;

    public function index()
    {
        $this->collection = !isset($this->collection) ? $this->resource : $this->collection;
        $this->collection = $this->collection->where(
            $this->defaults()
        );
        if ($this->relationships) {
            $this->collection->with(array_keys($this->relationships));
        }
        $this->handleFilters();
        $this->result_set = $this->collection->paginate($this->page_size);

        return $this->buildResponse('index');
    }

    public function show($id)
    {
        $this->findResourceAndAuthorize($id);

        return $this->buildResponse('show');
    }

    public function store()
    {
        $this->validateInput();

        $this->atts   = array_merge($this->atts, $this->defaults());
        $this->record = $this->resource->create($this->atts);
        $this->handleRelations();

        return $this->buildResponse('store');
    }

    public function update($id)
    {
        $this->validateInput();

        $this->findResourceAndAuthorize($id);
        $this->atts = array_merge($this->atts, $this->defaults());
        $this->record->update($this->atts);
        $this->handleRelations();

        $this->record = $this->record->fresh();

        return $this->buildResponse('update');
    }

    public function destroy($id)
    {
        $this->findResourceAndAuthorize($id);
        $this->record->delete();

        return $this->buildResponse('destroy');
    }
}
