<?php

namespace Bagaaravel\Api;

use Bagaaravel\Exceptions\ApiException;
use Illuminate\Support\Facades\Validator;

trait ApiGateway
{
    /**
     * Validate input based on validation rules
     *
     * @param  int  $id
     * @return Resource
     */
    private function validateInput()
    {
        $validator = Validator::make($this->attributes, $this->validation_rules);
        if ($validator->fails()) {
            throw new ApiException($validator->messages(), 422);
        }
    }
}
