<?php

namespace Bagaaravel\Laravel;

use Illuminate\Support\ServiceProvider;

class BagaaravelServiceProvider extends ServiceProvider
{

    public function boot()
    {
        $this->loadViewsFrom(__DIR__ . '/../views', 'bagaaravel');
    }

    public function register()
    {
        $this->prepareResources();
    }

    /**
     * Prepare the package resources.
     *
     * @return void
     */
    protected function prepareResources()
    {
        // Publish config
        $config = realpath(__DIR__ . '/../config/config.php');

        $this->mergeConfigFrom($config, 'bagaaravel');

        $this->publishes([
            $config => config_path('bagaaravel.php'),
        ], 'config');

        // Publish migrations
        $migrations = realpath(__DIR__ . '/../migrations');

        $this->publishes([
            $migrations => $this->app->databasePath() . '/migrations',
        ], 'migrations');

        // publish translations
        $this->publishes([
            __DIR__ . '/../translations' => base_path('resources/lang/vendor/bagaaravel'),
        ]);

        // publish views
        $this->publishes([
            __DIR__ . '/../views' => base_path('resources/views/vendor/bagaaravel'),
        ]);
    }
}
