# Bagaaravel package
## work in progress

* Explain package usage
* Registering with service providers 
* Add aliases
* Publish configurations
* Create basic controllers
* Routes

## Installation instructions

### External packages and their installation needs...
Follow instructions for:

* [cartalyst/sentinel](https://github.com/cartalyst/sentinel)
* [lucadegasperi/oauth2-server-laravel](https://github.com/lucadegasperi/oauth2-server-laravel)

### Install Bagaaravel extensions

## OAuth2
* Add in `config/app.php` the `Bagaaravel\Laravel\BagaaravelServiceProvider::class,` to the `providers` array.
* Delete `'middleware' => 'web'` from `mapWebRoutes` function in `RouteServiceProvider.php`
* Add to `config/oauth2.php` the following (as the `grant_types` array)

```php
  'password'      => [
    'class'            => '\Bagaaravel\Grants\PasswordGrant',
    'callback'         => '\Bagaaravel\Models\User@authenticate',
    'access_token_ttl' => 3600,
  ],
  'refresh_token' => [
    'class'             => '\Bagaaravel\Grants\RefreshTokenGrant',
    'access_token_ttl'  => 3600,
    'refresh_token_ttl' => 36000,
  ],
```

## Authorization middleware

You can use `Bagaaravel\Middleware\AuthorizationMiddleware` to authorize by role (Sentinel) on your route groups.
Add it to `app/Http/Kernel.php` at the bottom under `$routeMiddleware` as follows:

```php
'authorize' => \Bagaaravel\Middleware\AuthorizationMiddleware::class,
```

This way you can use it in your routes by utilizing the middleware argument on your `Route` definitions, example:

```php
// make sure this is defined within an oauth middleware group, or add it in the array before the authorize middleware
Route::group(['prefix' => 'admin', 'middleware' => 'authorize:admin'], function () {
  Route::resource('clients', 'Admin\ClientsController');
});
```

`admin` is the slug for that particular Role. You can also 'permit' multiple roles by `+`, so f.e. `authorize:admin+moderator`.

## Exception handling
Add in `Exceptions/Handler.php` at the top: 

```php
use Bagaaravel\Exceptions\ApiException;
use Bagaaravel\Exceptions\JsonApiErrorException;
use Bagaaravel\Exceptions\ApiExceptionHandler;
```

Add the exception classes to `$dontReport`:

```php
protected $dontReport = [ ...
  JsonApiErrorException::class,
  ApiException::class,
];
```

And in the `render()` method the following before the `return` statement:

```php
if ($e instanceof ApiException || $e instanceof JsonApiErrorException) {
  return ApiExceptionHandler::render($e);
}
```

### Publish assets for this package
You have to publish the config, translations and migrations first:
`php artisan vendor:publish --provider="Bagaaravel\Providers\BagaaravelServiceProvider"`