# Bagaaravel
A package by [Bagaar](https://bagaar.be) helping you augment your Laravel app with a great set of ready-made code!  
__Note: this is a work in progress__ (i don't think we can ever remove this line)

This package includes mainly code to kickstart your JSON Api's, have a solid authentication/authorization system in place and CRUD endpoint handling to get you started. You can use the mainly [jsonapi.org](http://jsonapi.org) compliant stuff or have something more custom[?](http://i.imgur.com/TnQRX6v.gifv).

## Table of contents
Skip to the relevant parts

* [Installation](#installation-instructions)
* [OAuth2](#oauth2)
* [Authorizations](#authorizations)
* [Exception handling](#exception-handling)
* [JSONApi integration](#jsonapi-integration)
	* [Model configuration](#model-configuration)
	* [Controller setup](#controller-setup)
	* [Scoping & authorization](#scoping-authorization)
* [Password management](#password-management)


## Installation instructions

Add package to composer

```bash
composer config repositories.bagaaravel vcs git@git.bagaar.be:shelf/bagaaravel.git
composer require bagaar/bagaaravel
```

#### External packages and their installation needs...
Follow instructions (Laravel 5) for:

* [cartalyst/sentinel](https://cartalyst.com/manual/sentinel/2.0#laravel-5)
* [lucadegasperi/oauth2-server-laravel](https://github.com/lucadegasperi/oauth2-server-laravel/blob/master/docs/getting-started/laravel-5.md)

Add in `config/app.php` in the `$providers` array the following service providers:

```php
Bagaaravel\Laravel\BagaaravelServiceProvider::class,
```

You have to publish the config, translations and migrations:

```bash
php artisan vendor:publish --provider="Bagaaravel\Providers\BagaaravelServiceProvider"
```

Don't forget to implement [exception handling](#exception-handling) when you're using one of the `ApiGateway` or `JSONApi` classes.

## OAuth2
* Delete `'middleware' => 'web'` from `mapWebRoutes` function in `RouteServiceProvider.php`
* Add to `config/oauth2.php` the following (as the `grant_types` array)


```php
  'password'      => [
    'class'            => '\Bagaaravel\Grants\PasswordGrant',
    'callback'         => '\Bagaaravel\Models\User@authenticate',
    'access_token_ttl' => 3600,
  ],
  'refresh_token' => [
    'class'             => '\Bagaaravel\Grants\RefreshTokenGrant',
    'access_token_ttl'  => 3600,
    'refresh_token_ttl' => 36000,
  ],
```

## Authorizations

You can use `Bagaaravel\Middleware\AuthorizationMiddleware` to authorize by role (Sentinel) on your route groups.
Add it to `app/Http/Kernel.php` at the bottom under `$routeMiddleware` as follows:

```php
'authorize' => \Bagaaravel\Middleware\AuthorizationMiddleware::class,
```

This way you can use it in your routes by utilizing the middleware argument on your `Route` definitions, example:

```php
// make sure this is defined within an oauth middleware group, or add it in the array before the authorize middleware
Route::group(['prefix' => 'admin', 'middleware' => 'authorize:admin'], function () {
  Route::resource('clients', 'Admin\ClientsController');
});
```

`admin` is the slug for that particular Role. You can also 'permit' multiple roles by `+`, so f.e. `authorize:admin+moderator`.

## Exception handling
Add in `Exceptions/Handler.php` at the top: 

```php
use Bagaaravel\Exceptions\ApiException;
use Bagaaravel\Exceptions\JsonApiErrorException;
use Bagaaravel\Exceptions\ApiExceptionHandler;
```

Add the exception classes to `$dontReport`:

```php
protected $dontReport = [ ...
  JsonApiErrorException::class,
  ApiException::class,
];
```

And in the `render()` method the following before the `return` statement:

```php
if ($e instanceof ApiException || $e instanceof JsonApiErrorException) {
  return ApiExceptionHandler::render($e);
}
```

## JSONApi integration

### Model configuration
Open up the `config/bagaaravel.php` file (you did publish the assets did you?). There's an example that you can use as a kickstarter:

```php
'jsonapi' => [
	'clients'   => [
		'model'         => \App\Models\Client::class,
		'filters'       => ['status', 'last_name', 'coupon'],
		'relationships' => ['user', 'addresses'],
	],
],
```
You can use `filters` to define what parameters the resultset can be filtered on, `relationships` defines all the model relationships, in this case `Client` belongs to a `User` and has many `Address`.

### Controller setup
Working with the `Client` model defition from above, create your controller, just `use Bagaaravel\Api\JsonApiController;` and extend that class. Define some `vars` and add it to your route:

```php

# Http/Controllers/Admin/ClientsController.php
<?php namespace App\Http\Controllers\Admin;

use Bagaaravel\Api\JsonApiController;

class ClientsController extends JsonApiController
{
    protected $route      = 'admin.clients'; // route name to use to link to resources
    protected $model      = 'clients'; // this reflects the name in the config
    protected $page_size  = 25; // records to show per page, default = 10
    protected $validation = [
        'last_name' => 'min:3',
    ]; // validaton rules for creating/updating

}

# Http/routes.php
Route::resource('clients', 'Admin\ClientsController');

```

### Scoping & Authorization

You can use the `setupScope()` function to setup the collection or resource references:

```
public function setupScope()
{
    $this->resource = $this->resource->where(['user_id' => Authorizer::getResourceOwnerId()]);
    parent::setupScope();
}
```

You can set the `$user_mapping` to an attribute that points to the user if necessary in the controller:

```
protected $user_mapping = 'user_id';
```


### Extend functions

You can easily extend a function used in the `JsonApiTrait.php` by defining the function and ending it with a call to the parent:

```php

public function handleFilters()
{
    $filters = Input::get('filter', []);
    if (isset($filters['email'])) {
        $users            = User::where('email', 'LIKE', '%' . $filters['email'] . '%')->lists('id');
        $this->collection = $this->collection->with(['user'])->whereIn('user_id', $users);
    }
	parent::handleFilters();
}
    
```

## Password management
wip