<?php namespace Bagaaravel\Exceptions;

use Illuminate\Http\Response;

class ApiExceptionHandler
{

    public static function render($e, $custom = null)
    {
        if ($custom) {

            $payload = $custom;

        } else {

            $code    = $e->getCode();
            $message = $e->getMessage();
            $errors  = [];
            $headers = [];

            if ($e instanceof JsonApiErrorException) {
                $headers[] = ['Content-Type' => 'application/vnd.api+json'];
            }

            if ($code == Response::HTTP_UNPROCESSABLE_ENTITY && json_decode($message) != null) {

                if ($e instanceof ApiException) {

                    $errors             = json_decode($message);
                    $payload['message'] = 'VALIDATION_FAILED';
                    $payload['code']    = $code;

                } else {

                    foreach (json_decode($message) as $key => $details) {
                        foreach ($details as $detail) {
                            $errors[] = [
                                'status' => Response::HTTP_UNPROCESSABLE_ENTITY,
                                'source' => $key,
                                'detail' => $detail,
                            ];
                        }
                    }

                }

            } else {

                $errors[] = [
                    'status' => $code,
                    'source' => $message,
                ];

            }

            $payload['errors'] = $errors;
        }

        return response()
            ->json($payload, $code)
            ->withHeaders($headers);
    }
}
