<?php

namespace Bagaaravel\Api;

trait JSONResponders
{

    /**
     * Return a response json object
     *
     * @param $object
     * @param $status
     * @param array $headers
     *
     * @return Response
     */
    public function respond($object, $status = 200, $headers = [])
    {
        return response()->json($object, $status)->withHeaders($headers);
    }

    /**
     * Respond with collection of objects
     *
     * @param $collection
     * @return Response
     */
    public function respondCollection($collection, $status = 200)
    {
        return $this->respond(['data' => $collection]);
    }

    /**
     * Respond with object
     *
     * @param $item
     * @return Response
     */
    public function respondItem($item, $status = 200)
    {
        return $this->respond(['data' => $item], $status);
    }
}
