<?php

namespace Bagaaravel\Acl\Models;

use Illuminate\Database\Eloquent\Model;

class Role extends Model
{
    protected $fillable = ['slug', 'name'];

    public function permissions()
    {
        return $this->belongsToMany(Permission::class);
    }

    public function users()
    {
        return $this->belongsToMany(config('bagaaravel-acl.user'));
    }

    public function assignPermission($permission)
    {
        return $this->permissions()->save(
            Permission::whereSlug($permission)->firstOrFail()
        );
    }
}
