<?php

namespace Bagaaravel\Api\Repositories;

/**
 * Class GenericRepository
 * @package Bagaaravel\Api\Repositories
 */
class GenericRepository implements RepositoryInterface
{

    /**
     * @var
     */
    protected $model;
    protected $filters = [];
    protected $sorting = [];

    /**
     * @param $model
     */
    public function setModel($model)
    {
        $this->model = app($model);
    }

    /**
     * @param $filters
     */
    public function setFilters($filters)
    {
        $this->filters = $filters;
    }

    public function applyFilters($model)
    {
        foreach ($this->filters as $field => $value) {
            if (strpos($value, '%') !== false) {
                $model->where($field, 'LIKE', $value);
            } else {
                $model->where($field, '=', $value);
            }
        }
        return $model;
    }

    /**
     * @param $sorting
     */
    public function setSorting($sorting)
    {
        $this->sorting = $sorting;
    }

    public function applySorting($model)
    {
        foreach ($this->sorting as $sort) {
            $model->orderBy($sort['key'], $sort['direction']);
        }
        return $model;
    }

    /**
     * @return mixed
     */
    public function getAll()
    {
        $model = $this->model->select('*');
        $model = $this->applyFilters($model);
        $model = $this->applySorting($model);
        return $model->get();
    }

    /**
     * @param int $per_page
     * @return mixed
     */
    public function getAllPaginated($per_page = 20)
    {
        $model = $this->model->select('*');
        $model = $this->applyFilters($model);
        $model = $this->applySorting($model);
        return $model->paginate($per_page);
    }


    /**
     * @param $scope
     * @return mixed
     */
    private function getAllWhereModel($scope)
    {
        $model = $this->model;
        foreach ($scope as $field => $value) {
            if (strpos($value, '%') !== false) {
                $model = $model->where($field, 'LIKE', $value);
            } else {
                $model = $model->where($field, '=', $value);
            }
        }
        return $model;
    }

    /**
     * @param $scope
     * @return mixed
     */
    public function getAllWhere($scope)
    {
        $model = $this->getAllWhereModel($scope);

        return $model->get();
    }


    /**
     * @param     $scope
     * @param int $per_page
     * @return mixed
     */
    public function getAllWherePaginated($scope, $per_page = 20)
    {
        $model = $this->getAllWhereModel($scope);

        return $model->paginate($per_page);
    }

    /**
     * @param $id
     * @return mixed
     */
    public function getById($id)
    {
        return $this->model->findOrFail($id);
    }


    /**
     * @param array $ids
     * @return mixed
     */
    public function getAllIn(Array $ids)
    {
        return $this->model->whereIn('id', $ids)->get();
    }

    /**
     * @param null $input
     * @return mixed
     */
    public function create($input = null)
    {
        if ($input) {
            return $this->model->create($input);
        } else {
            return $this->model->newInstance();
        }
    }

    /**
     * @param $id
     * @param $input
     * @return bool|mixed
     */
    public function save($id, $input)
    {
        $row = $this->getById($id);
        if ($row) {
            $row->fill($input)->save();
            return $row;
        }
        return false;
    }

    /**
     * @param $id
     * @return mixed
     */
    public function delete($id)
    {
        $row = $this->getById($id);

        return $row->delete();
    }

}