<?php
namespace Bagaaravel\Api\Requests;

use Illuminate\Contracts\Validation\Validator;

class GenericJsonApiFormRequest extends GenericFormRequest implements FormRequestInterface
{

    protected $failedRules = [];

    public function authorize()
    {
            return true;
    }

    /**
     * @param Validator $validator
     * @throws \Illuminate\Validation\ValidationException
     */
    protected function failedValidation(Validator $validator)
    {
        $this->failedRules = $validator->failed();
        parent::failedValidation($validator);
    }


    /**
     * Get the proper failed validation response for the request.
     *
     * @param  array  $errors
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function response(array $errors)
    {
        $response_errors = [];

        foreach( $errors as $field => $messages ){

            foreach( $messages as $message_index => $message ){

                $rule = array_keys($this->failedRules[$field])[$message_index];

                $err = [
                    'status' => 422,
                    'source' => ['pointer' => '/data/attributes/' . $field],
                    'title' => $rule,
                    'detail' => $message
                ];

                $response_errors[] = $err;
            }
        }

        return response()->json(['errors' => $response_errors], 422)->withHeaders(['Content-Type' => 'application/vnd.api+json']);
    }

    /**
     * @throws \HttpException
     */
    public function forbiddenResponse()
    {
        abort(403);
    }


    /**
     * @return array|string
     */
    protected function validationData()
    {
        return $this->input('data.attributes', []);
    }

}