    # Bagaaravel
A package by [Bagaar](https://bagaar.be) helping you augment your Laravel app with a great set of ready-made code!  
__Note: this is a work in progress__ (i don't think we can ever remove this line)

This package includes mainly code to kickstart your JSON Api's, have a solid authentication/authorization system in place and CRUD endpoint handling to get you started. You can use the mainly [jsonapi.org](http://jsonapi.org) compliant stuff or have something more custom[?](http://i.imgur.com/TnQRX6v.gifv).

## Table of contents
Skip to the relevant parts

* [Installation](#installation-instructions)
* [Authorizations](#authorizations)
* [Exception handling](#exception-handling)
* [JSONApi integration](#jsonapi-integration)
	* [Model configuration](#model-configuration)
	* [Controller setup](#controller-setup)
	* [Routes setup](#routes-setup)
	* [Custom configuration](#custom-configuration)


## Installation instructions

Add the bagaar repository to composer.json
```json
{
    ...
    
    "repositories": [
      {
        "type": "composer",
        "url": "https://composer.bagaar.be"
      }
    ]
}
```
Then require the package
```bash
composer require bagaar/bagaaravel
```



Add in `config/app.php` in the `$providers` array the following service providers:

```php
<?php

$providers = [
//    
Bagaaravel\Laravel\BagaaravelServiceProvider::class,
Bagaar\Acl\BagaarAclServiceProvider::class,
//
];
```

You have to publish the config, translations and migrations: `php artisan vendor:publish`

Then run `php artisan passport:install`

Add the passport routes to the boot() method of AuthServiceProvider.php:
```php
<?php

public function boot()
{
    $this->registerPolicies();

    \Laravel\Passport\Passport::routes();
}
```

## Authorizations

In config/bagaar_acl.php set the user key to your User model and some default roles:

```php
return [
    'user' => App\Models\User::class,

    'defaults' => [
        'administrators' => 'Administrators',
        'users' => 'Users'
    ]   
];
```

Now you can run `php artisan bagaar:acl:default` to install these roles.

Now import the HasRoles trait in your User model:

```php
use Bagaaravel\Models\HasRoles;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use Notifiable, HasRoles;
```

You can use `Bagaaravel\Middleware\AuthorizationMiddleware` to authorize by role on your route groups.
Add it to `app/Http/Kernel.php` at the bottom under `$routeMiddleware` as follows:

```php
protected $routeMiddleware = [
    //
    'role' => \Bagaar\Acl\Middleware\CheckRole::class
];

```

Now you can protect your routes like so:
```php
Route::group(['middleware' => 'role:administrators'], function(){
	// routes
});
```
Where the parameter of the middleware is the name of the role you want to give access to.

`administrators` is the slug for that particular Role. You can also 'permit' multiple roles by `+`, so f.e. `authorize:administrators+moderators`.

With the command `php artisan bagaar:acl:addrole` you can create new roles.

## Exception handling
Add in `Exceptions/Handler.php` at the top: 

```php
use Bagaaravel\Api\Responders\ApiResponder;
```
Modify the `render()` method:

```php
public function render($request, Exception $exception)
{
    if ($request->wantsJson()) {
        return app(ApiResponder::class)->respondException($exception);
    }
    return parent::render($request, $exception);
}
```

## JSONAPI integration

### Model configuration
Open up the `config/bagaaravel.php` file (you did publish the assets did you?). There's an example that you can use as a kickstarter:

```php
'jsonapi' => [
    'Client' => [
        'model' => \App\Models\Client::class,
        'relationships' => [
            'phone' => 'Phone',
            'types' => 'Type',
            'notes' => 'Note',
            'tags' => 'Tag'
        ]
    ],
    
    'Phone' => [
        'model' => \App\Models\Phone::class,
        'relationships' => [
            'client' => 'Client'
        ]
    ],
],
```
You can use `filters` to define what parameters the resultset can be filtered on, `relationships` defines all the model relationships (format is: model method => type definition in config), in this case `Client` belongs to a `User` and has many `Address`. Property `owner`  (default is `user_id`) defines the attribute that 'owns' the model (mostly received by querying the `Authorizer`).

### Controller setup
Working with the `Client` model defition from above, create your controller, just `use Bagaaravel\Api\JsonApiController;` and extend that class. Define some `vars` and add it to your route:

```php

# Http/Controllers/Admin/ClientsController.php
<?php
namespace App\Http\Controllers\JsonApi;

use Bagaaravel\Api\JsonApiController;

class ClientController extends JsonApiController
{

    public static $model = 'Client';

    public function defaults()
    {
        // TODO: Implement defaults() method.
    }
}
```
### Routes setup
Create your resource routes with ::jsonapi instead of ::resource
```php

# Http/routes.php
<?php

Route::jsonapi('clients', 'JsonApi\ClientController');

```
### Custom configuration

See features https://git.bagaar.be/shelf/bagaar-test-api/tree/master/features/JsonApiController for explanation. 