<?php
namespace Bagaaravel\Api\Transformers;

class GenericJsonApiTransformer extends Transformer implements TransformerInterface
{

    /**
     * @param $item
     * @return mixed
     */
    public function transformItem($item)
    {
        $hidden = ['id', 'created_at', 'updated_at', 'pivot'];

        foreach( $this->relationships as $relationship => $model ){
            $hidden[] = $relationship;
            if ( method_exists($item, $relationship) ){
                $hidden[] = $item->{$relationship}()->getForeignKey();
            }
        }

        //check if item is polymorphic
        if ( method_exists($item, class_basename($item) . 'able') ){
            $basename = class_basename($item);
            $hidden[] = snake_case($basename) . 'able_id';
            $hidden[] = snake_case($basename) . 'able_type';
        }

        $item->makeHidden($hidden);
        return $item->toArray();
    }
}