<?php

namespace Bagaaravel\Laravel;

use Bagaaravel\Api\Requests\GenericJsonApiFormRequest;
use Bagaaravel\Api\Responders\ApiResponder;
use Bagaaravel\Api\Responders\JsonApiResponder;
use Bagaaravel\Api\Responders\ResponderInterface;
use Bagaaravel\Models\DummyPolicyModel;
use Bagaaravel\Policies\DummyPolicy;
use Illuminate\Routing\Router;
use Illuminate\Support\ServiceProvider;
use Bagaaravel\Api\Requests\GenericFormRequest;
use Bagaaravel\Api\Requests\FormRequestInterface;

class BagaaravelServiceProvider extends ServiceProvider
{
    protected $controller;

    protected $policies = [
        DummyPolicyModel::class => DummyPolicy::class
    ];

    public function boot()
    {
        $this->registerPolicies();

        $this->loadTranslationsFrom(__DIR__ . '/../translations', 'bagaaravel');
        $this->loadViewsFrom(__DIR__ . '/../views', 'bagaaravel');

        $appNamespace = $this->getAppNamespace();

        Router::macro('jsonapi', function($name, $controller, array $options = []) use ($appNamespace){
            \Route::resource($name, $controller, array_merge([
                'only' => ['index', 'store', 'update', 'show', 'destroy']
            ], $options));

            $groupStack = \Route::getGroupStack();
            $lastGroup = array_pop($groupStack);

            $full_controller_path = '\\' . $lastGroup['namespace'] . '\\' . $controller;
            $config_key = $full_controller_path::$model;
            $config = config('bagaaravel.jsonapi.' . $config_key);

            if ( isset($config['relationships']) ){
                foreach( $config['relationships'] as $rel_name => $rel_config_key ){
                    \route::get($name . '/{item}/' . $rel_name, ['as' => $name . '.related.' . $rel_name . '.show', 'uses' => $controller . '@related_resource_show' ]);
                    \route::get($name . '/{item}/relationships/' . $rel_name, ['as' => $name . '.relation.' . $rel_name . '.show', 'uses' => $controller . '@relationships_show' ]);
                    \route::post($name . '/{item}/relationships/' . $rel_name, ['as' => $name . '.relation.' . $rel_name . '.update', 'uses' => $controller . '@relationships_store' ]);
                    \route::delete($name . '/{item}/relationships/' . $rel_name, ['as' => $name . '.relation.' . $rel_name . '.update', 'uses' => $controller . '@relationships_delete' ]);
                    //\route::match(['PUT', 'PATCH'], $name . '/{item}/relationships/' . $rel_name, ['as' => $name . '.relation.' . $rel_name . '.update', 'uses' => $controller . '@relationships_update' ]);

//                    \route::post($name . '/{item}/' . $rel_name, ['as' => $name . '.relation.' . $rel_name . '.store', 'uses' => $controller . '@relation_store_'.$rel_name ]);
//                    \route::match(['PUT', 'PATCH'], $name . '/{item}/' . $rel_name, ['as' => $name . '.relation.' . $rel_name . '.update', 'uses' => $controller . '@relation_update_'.$rel_name ]);
//                    \route::delete($name . '/{item}/' . $rel_name, ['as' => $name . '.relation.' . $rel_name . '.delete', 'uses' => $controller . '@relation_delete_'.$rel_name ]);
                }
            }
        });
    }

    public function register()
    {
        $this->prepareResources();
        /*
         * TODO commands for scaffolding
         */
//        $this->commands([
//            BagaaravelControllerGenerator::class,
//            BagaaravelResourceGenerator::class,
//            BagaaravelModelGenerator::class,
//        ]);

        $this->app->bind(FormRequestInterface::class, function () {

            list($controller, $action) = explode('@', request()->route()->getActionName());
            $key = $controller::$model;
            $formRequest = ucfirst($key) . ucfirst($action) . 'Request';

            if (class_exists($this->getAppNamespace() . "Http\\Requests\\${formRequest}")) {
                return app($this->getAppNamespace() . "Http\\Requests\\${formRequest}");
            }

            $controller_parents = class_parents($controller);
            if ( in_array('Bagaaravel\Api\JsonApiController', $controller_parents) ){
                return app(GenericJsonApiFormRequest::class);
            }

            return app(GenericFormRequest::class);
        });

        $this->app->bind(ResponderInterface::class, function($app){

            if( \App::runningInConsole() && $this->app->environment() != 'behat' ){
                return new ApiResponder( (isset($params[0]) ? $params[0] : null) );
            }

            list($controller, $action) = explode('@', request()->route()->getActionName());

            $constructorParam = $controller::$model;

            $controller_parents = class_parents($controller);
            if ( in_array('Bagaaravel\Api\JsonApiController', $controller_parents) ){
                return new JsonApiResponder($constructorParam);
            }

            return new ApiResponder($constructorParam);
        });
    }

    /**
     * Prepare the package resources.
     *
     * @return void
     */
    protected function prepareResources()
    {
        // Publish config
        $this->mergeConfigFrom(__DIR__ . '/../config/config.php', 'bagaaravel');
        $this->publishes([__DIR__ . '/../config/config.php' => config_path('bagaaravel.php')]);

        // Publish migrations
        $this->loadMigrationsFrom(__DIR__ . '/../migrations');

        // publish translations
        $this->publishes([__DIR__ . '/../translations' => base_path('resources/lang/vendor/bagaaravel')]);

        // publish views
        $this->publishes([__DIR__ . '/../views' => base_path('resources/views/vendor/bagaaravel')]);
    }


    public function registerPolicies()
    {
        foreach ($this->policies as $key => $value) {
            \Gate::policy($key, $value);
        }
    }

    protected function getAppNamespace()
    {
        return \Illuminate\Container\Container::getInstance()->getNamespace();
    }
}
