<?php

namespace Bagaaravel\Api\Requests;

use Illuminate\Foundation\Http\FormRequest;

class GenericFormRequest extends FormRequest implements FormRequestInterface
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        list($controller, $action) = explode('@', request()->route()->getActionName());
        if ($action === 'delete') {
            return [];
        }
        $controller = app($controller);
        $key = $controller::$model;

        return config("bagaaravel.jsonapi.${key}.validation_rules", []);
    }
}
