<?php

namespace Bagaaravel\Commands;

use Illuminate\Console\Command;
use Illuminate\Filesystem\Filesystem;

class BagaaravelControllerGenerator extends Command
{
    protected $signature = 'bagaar:controller {name : The Controller name} {model : The Model name} {type : The Controller type API or JSONAPI}';
    protected $description = 'Generate API & JSONAPI Controllers';
    private $filesystem;
    private $composer;
    private $namespace;
    private $controller;
    private $type;
    private $model;

    public function __construct(Filesystem $filesystem)
    {
        $this->filesystem = $filesystem;
        parent::__construct();
    }

    public function handle()
    {
        $this->controller = trim($this->input->getArgument('name'));
        $this->type = strtolower(trim($this->input->getArgument('type')));
        $this->namespace = $this->getAppNamespace();
        $this->model = '\\' . $this->namespace . 'Models\\' . ucfirst(trim($this->input->getArgument('model')));
        $this->{$this->type}();
    }

    protected function api()
    {
        $template = $this->filesystem->get(__DIR__.'/../Templates/ApiController.tpl');
        $template = str_replace('%CLASSNAME%', $this->controller, $template);
        $template = str_replace('%MODEL%', $this->model, $template);
        $template = str_replace('%NAMESPACE%', $this->namespace . 'Http\Controllers;', $template);
        $this->filesystem->put(app_path('Http/Controllers/' . $this->controller . '.php'), $template);
    }

    protected function jsonapi()
    {

    }

    protected function getAppNamespace()
    {
        return \Illuminate\Container\Container::getInstance()->getNamespace();
    }
}
