<?php

namespace Bagaaravel\Commands;

use Illuminate\Console\Command;

class BagaaravelResourceGenerator extends Command
{
    protected $signature = 'bagaar:resource {name : The Resource name}';
    protected $description = 'Generate API & JSONAPI Resources';
    private $namespace;
    private $resourceName;
    private $model;

    public function handle()
    {
        $this->resourceName = ucfirst(trim($this->input->getArgument('name')));
//        $this->type = strtolower(trim($this->input->getArgument('type')));
        $this->namespace = $this->getAppNamespace();
        $this->model = '\\' . $this->namespace . 'Models\\' . $this->resourceName;
        \Artisan::call('make:model', ['name' => 'Models/Carrot']);
        \Artisan::call('bagaar:controller', ['name' => 'CarrotsController', 'model' => 'Carrot', 'type' => 'api']);
    }

    protected function getAppNamespace()
    {
        return \Illuminate\Container\Container::getInstance()->getNamespace();
    }
}