<?php

namespace Bagaaravel\Api\Transformers;

use Illuminate\Database\Eloquent\Collection;

abstract class Transformer implements TransformerInterface
{
    protected $config;
    protected $relationships = [];

    /**
     * @param $config
     */
    public function setConfig($config)
    {
        $this->config = config('bagaaravel.jsonapi.' . $config);
        if ( isset($this->config['relationships']) ) $this->relationships = $this->config['relationships'];
    }

    /**
     * @param $items
     * @return \Illuminate\Support\Collection
     */
    public function transform($items)
    {
        if ($items instanceof Collection) {
            return $this->transformItems($items);
        }
        return $this->transformItem($items);
    }

    /**
     * @param Collection $items
     * @return \Illuminate\Support\Collection
     */
    public function transformItems(Collection $items)
    {
        return $items->map(function ($item) {
            return $this->transformItem($item);
        });
    }

    /**
     * @param $item
     * @return mixed
     */
    public abstract function transformItem($item);
}