<?php

namespace Bagaaravel\Guards;


use App\Models\User;
use Illuminate\Http\Request;
use Laravel\Passport\Guards\TokenGuard;


class BagaarGuard extends TokenGuard
{
    /**
     * Get the user for the incoming request.
     *
     * @param  Request  $request
     * @return mixed
     */
    public function user(Request $request)
    {
        // Make it possible on local & staging environment to add 'dev-only' as bearer token
        // to login as the first user in the DB.
        if(in_array(env('APP_ENV'), ['staging', 'local', 'behat', 'testing']) && $request->bearerToken() == 'dev-only')
        {
            return $this->provider->retrieveById(User::first()->id);
        }

        return parent::user($request);
    }
}