<?php
namespace Bagaaravel\Api\Transformers;

class GenericJsonApiTransformer extends Transformer implements TransformerInterface
{

    /**
     * @param $item
     * @return mixed
     */
    public function transformItem($item)
    {
        if (\Config::get('bagaaravel.timestamps_visible', false)) {
            $hidden = ['id', 'pivot'];
        } else {
            $hidden = ['id', 'created_at', 'updated_at', 'pivot'];
        }

        foreach( $this->relationships as $relationship => $model ){
            $hidden[] = $relationship;
            if ( method_exists($item, $relationship) ){
                if (method_exists($item->{$relationship}(), 'getForeignKey')) {
                    $hidden[] = $item->{$relationship}()->getForeignKey();
                } else if(method_exists($item->{$relationship}(), 'getQualifiedForeignKeyName'))  {
                    $hidden[] = $item->{$relationship}()->getQualifiedForeignKeyName();
                }
                else {
                    $hidden[] = $item->{$relationship}()->getQualifiedParentKeyName();
                }
            }
        }

        //check if item is polymorphic
        if ( method_exists($item, class_basename($item) . 'able') ){
            $basename = class_basename($item);
            $hidden[] = snake_case($basename) . 'able_id';
            $hidden[] = snake_case($basename) . 'able_type';
        }

        $item->makeHidden($hidden);
        return $item->toArray();
    }
}