<?php
namespace Bagaaravel\Api\Requests;

use Illuminate\Contracts\Validation\Validator;

class GenericJsonApiFormRequest extends GenericFormRequest implements FormRequestInterface
{

    protected $failedRules = [];


    public function authorize()
    {
            return true;
    }


    public function rules()
    {
        //if it is a relationships request, disable validation rules
        $segments = $this->segments();
        if ( count($segments) >= 2 && $segments[count($segments) - 2] == 'relationships' ){
            return [];
        }

        return parent::rules();
    }


    /**
     * @param Validator $validator
     * @throws ValidationException
     */
    protected function failedValidation( Validator $validator )
    {
        $this->failedRules = $validator->failed();
        if ( app()->version() < '5.5' ) {
            return parent::failedValidation($validator);
        }

        $response_errors = [];
        $errors = $validator->errors()->toArray();

        foreach ( $errors as $field => $messages ) {

            foreach ( $messages as $message_index => $message ) {

                $rule = array_keys($this->failedRules[$field])[$message_index];

                $err = [
                    'status' => 422,
                    'source' => ['pointer' => '/data/attributes/' . $field],
                    'title'  => $rule,
                    'detail' => $message,
                ];

                $response_errors[] = $err;
            }
        }

        throw new \Illuminate\Http\Exceptions\HttpResponseException(response()->json(['errors' => $response_errors], 422)->withHeaders(['Content-Type' => 'application/vnd.api+json']));
    }


    /**
     * Get the proper failed validation response for the request.
     *
     * @param  array  $errors
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function response(array $errors)
    {
        $response_errors = [];

        foreach( $errors as $field => $messages ){

            foreach( $messages as $message_index => $message ){

                $rule = array_keys($this->failedRules[$field])[$message_index];

                $err = [
                    'status' => 422,
                    'source' => ['pointer' => '/data/attributes/' . $field],
                    'title' => $rule,
                    'detail' => $message
                ];

                $response_errors[] = $err;
            }
        }

        return response()->json(['errors' => $response_errors], 422)->withHeaders(['Content-Type' => 'application/vnd.api+json']);
    }

    /**
     * @throws \HttpException
     */
    public function forbiddenResponse()
    {
        abort(403);
    }


    /**
     * @return array|string
     */
    protected function validationData()
    {
        return $this->input('data.attributes', []);
    }

}