<?php

namespace Bagaaravel\Http\Controllers\Auth;

use Bagaaravel\Http\Controllers\Controller;
use Bagaaravel\Http\Requests\PasswordForgotRequest;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Password;

class ForgotPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset emails and
    | includes a trait which assists in sending these notifications from
    | your application to your users. Feel free to explore this trait.
    |
    */

    use SendsPasswordResetEmails;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    public function sendResetLinkEmail(PasswordForgotRequest $request)
    {
        $response = $this->broker()->sendResetLink(
            $request->only('data.attributes.email')['data']['attributes']
        );

        return $response == Password::RESET_LINK_SENT
            ? $this->sendResetLinkResponse($response)
            : $this->sendResetLinkFailedResponse($request, $response);
    }

    /**
     * Get the response for a successful password reset link.
     *
     * @param  string  $response
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\JsonResponse
     */
    protected function sendResetLinkResponse($response)
    {
        return response()->json(null, 201)->withHeaders(['Content-Type' => 'application/vnd.api+json']);
    }

    /**
     * Get the response for a failed password reset link.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  string  $response
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\JsonResponse
     */
    protected function sendResetLinkFailedResponse(Request $request, $response)
    {
        return response()->json([
            'errors' => [
                [

                    'source' => ['pointer' => '/data/attributes/email'],
                    'status' => 422,
                    'detail' => trans($response)
                ]
            ]
        ], 422)->withHeaders(['Content-Type' => 'application/vnd.api+json']);
    }
}
