<?php

namespace Bagaaravel\Http\Middleware;

use Closure;

class CheckRole
{
    /**
     * Handle an incoming request.
     * For now parse only following formats role1|role2|role3 or role1&role2&role3
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, $role, $all = false)
    {
        $roles = explode('|', $role);

        if (! auth()->user()->hasRole($roles, $all)) {
            abort(403);
        }

        return $next($request);
    }
}
