<?php

namespace Bagaaravel\Api\Requests;

use Bagaaravel\Acl\Permissions\ResolverAwareTrait;
use Bagaaravel\Api\JsonCrudController;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;

class GenericFormRequest extends FormRequest implements FormRequestInterface
{
    use ResolverAwareTrait;
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function validateResolved()
    {
        parent::validateResolved();
        $this->checkRequest();
    }

    protected function checkRequest()
    {
        $route = request()->route();

        if($route == null) return;

        list($controller, $action) = explode('@', $route->getActionName());


        if ($action == 'store' || $action == 'update') {
            $key = $controller::$model;
            $config = config('bagaaravel.jsonapi.' . $key);
            $this->checkPermissions($config['model']);
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $route = request()->route();

        if($route == null)
        {
            return [];
        }

        list($controller, $action) = explode('@', $route->getActionName());
        if ($action === 'delete') {
            return [];
        }
        $controller = app($controller);
        $key = $controller::$model;

        return config("bagaaravel.jsonapi.${key}.validation_rules", []);
    }


    protected function failedValidation(Validator $validator)
    {
        throw  new \Illuminate\Http\Exceptions\HttpResponseException(response()->json($validator->errors()->toArray(),
            422));
    }

    public function checkPermissions($model)
    {
        $instance = $this->getModelInstance($model);

        $this->replace($this->filterWritable($instance, $this->input()));
    }

    protected function getModelInstance($model)
    {
        $instance = app($model);

        list($controller, $action) = explode('@', request()->route()->getActionName());

        if ($action === 'update') {
            $segments = $this->segments();
            $id = end($segments);
            $instance = $instance->find($id);
        }

        return $instance;

    }

    protected function getModelName(): ?String
    {
        $controller = app(strtok($this->route()->getActionName(), '@'));
        if ($controller instanceof JsonCrudController) {
            return $controller::$model;
        }
        return null;
    }

}
