<?php

namespace Bagaaravel\Policies;

use Bagaaravel\Models\DummyPolicyModel;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Auth\Access\HandlesAuthorization;

class DummyPolicy
{
    use HandlesAuthorization;

    public function view(Model $user, DummyPolicyModel $model)
    {
        return \Config::get('bagaaravel.policies.view');
    }

    public function create(Model $user)
    {
        return \Config::get('bagaaravel.policies.create');
    }

    public function update(Model $user, DummyPolicyModel $model)
    {
        return \Config::get('bagaaravel.policies.update');
    }

    public function delete(Model $user, DummyPolicyModel $model)
    {
        return \Config::get('bagaaravel.policies.delete');
    }

    public function index(Model $user, DummyPolicyModel $model)
    {
        //to remain backward compatible, we default to true
        //this will allow project that don't have 'bagaaravel.policies.index' defined to remain functional
        return \Config::get('bagaaravel.policies.index', true);
    }
}
