<?php

namespace Bagaaravel\Acl\Permissions;

class BasePermission
{
    const DEFAULT_PERMISSION = 'default_permission';
    const RELATIONSHIPS_PERMISSIONS = 'relationships_permissions';

    protected $rules = [];

    protected $defaultRules = [];

    /**
     * BasePermission constructor.
     * @param $rules
     */
    public function __construct($rules = null)
    {
        if ($rules) {
            $this->rules = $rules;
        }
        $this->defaultRules = config('bagaaravel-acl.default_permissions', []);
    }

    public function getRule($attribute, $role = 'default')
    {
        if (isset($this->rules[$role][self::RELATIONSHIPS_PERMISSIONS][$attribute])) {
            return $this->rules[$role][self::RELATIONSHIPS_PERMISSIONS][$attribute];
        }

        if (isset($this->rules[$role]) && isset($this->rules[$role][$attribute])) {
            return $this->rules[$role][$attribute];
        }

        if (isset($this->rules[$role][self::DEFAULT_PERMISSION])) {
            return $this->rules[$role][self::DEFAULT_PERMISSION];
        }

        if ($role == 'default' && isset($this->defaultRules[$role])) {
            return $this->defaultRules[$role];
        }

        return '';
    }

    public function getAttributes()
    {
        $attributes = [];

        foreach ($this->rules as $roleRules) {
            $onlyAttributes = array_filter($roleRules, function ($attribute) {
                return $attribute !== self::RELATIONSHIPS_PERMISSIONS;
            }, ARRAY_FILTER_USE_KEY);

            $attributes = array_unique(array_merge($attributes, array_keys($onlyAttributes)));
        }

        $methods = get_class_methods(static::class);

        foreach ($methods as $method) {
            if (strpos($method, 'rightsFor') === 0) {
                $attribute = lcfirst(substr($method, 9));
                if (!in_array($attribute, $attributes)) {
                    $attributes[] = $attribute;
                }
            }
        }

        return $attributes;
    }

    public function getRelationships()
    {
        $relationships = [];

        foreach ($this->rules as $roleRules) {
            if (isset($roleRules[self::RELATIONSHIPS_PERMISSIONS])) {
                $relationships = array_unique(array_merge($relationships, array_keys($roleRules[self::RELATIONSHIPS_PERMISSIONS])));
            }
        }

        $methods = get_class_methods(static::class);

        foreach ($methods as $method) {
            if (strpos($method, 'relationshipRightsFor') === 0) {
                $relationship = lcfirst(substr($method, 21));
                if (!in_array($relationship, $relationships)) {
                    $relationships[] = $relationship;
                }
            }
        }

        return $relationships;
    }
}