<?php

namespace Bagaaravel\Http\Requests;

use Bagaaravel\Api\Requests\GenericJsonApiFormRequest;

class PasswordResetRequest extends GenericJsonApiFormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth()->check() === false;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'email' => 'required',
            'token' => 'required',
            'password' => 'required|confirmed|min:6',
        ];
    }
}
