<?php

namespace Bagaaravel\Acl\Models\Detached;

use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Database\Eloquent\Concerns;

class Permission implements \ArrayAccess, Arrayable
{

    use Concerns\HasAttributes,
        Concerns\HasEvents,
        Concerns\HasGlobalScopes,
        Concerns\HasRelationships,
        Concerns\HasTimestamps,
        Concerns\HidesAttributes,
        Concerns\GuardsAttributes;


    protected $model;


    public function __construct($model)
    {
        $this->model = $model;

    }

    public function getKey(): string
    {
        return class_basename($this->model);
    }

    public function getModel()
    {
        return $this;
    }

    public function offsetExists($offset): bool
    {
        return isset($this->$offset);
    }

    public function offsetGet($offset): mixed
    {
        return $this->$offset;
    }

    public function offsetSet($offset, $value): void
    {
        $this->$offset = $value;
    }

    public function offsetUnset($offset): void
    {
        unset($this->$offset);
    }

    public function toArray(): array
    {
        return $this->attributes;
    }


    public function __get($key)
    {
        if (array_key_exists($key, $this->attributes)) {
            return $this->attributes[$key];
        }
        return null;
    }

    public function __set($key, $value)
    {
        $this->attributes[$key] = $value;
    }


}
