<?php
namespace Bagaaravel\Utils;

class ConfigHandler
{
    const DELIMITER = '|';

    public static function extractRelationType($type)
    {
        return strtok($type, self::DELIMITER);
    }

    public static function getRelationRequiredStatus($type)
    {
       $set = explode(self::DELIMITER, $type);
       return isset($set[1]) ? $set[1] : null;
    }

    public static function extractRelationships(array $relationships)
    {
        return array_map([ConfigHandler::class, 'extractRelationType'], $relationships);
    }
}