<?php

namespace Bagaaravel\Acl\Permissions;

trait ResolverAwareTrait
{
    /**
     * @var ResolverInterface
     */
    protected $resolver;

    /**
     * @return DummyResolver|Resolver|ResolverInterface
     */
    protected function getResolver()
    {
        if (!$this->resolver) {
            list($controller, $action) = explode('@', request()->route()->getActionName());
            $key = $controller::$model;

            $config = config('bagaaravel.jsonapi.' . $key);

            $this->resolver = $this->getResolverForModel($config['model'], $action);
        }

        return $this->resolver;
    }

    protected function getResolverForModel($model, $action = null)
    {
        $config = config('bagaaravel-acl.model_permissions', []);

        if (isset($config[$model])) {
            return new Resolver($config[$model], $action);
        } else {
            return new DefaultResolver(config('bagaaravel-acl.default_permissions', []), $action);
        }
    }

    protected function filterReadable($model, $fields)
    {
        return array_filter(
            $fields,
            function ($key) use ($model) {
                return $this->getResolver()->isReadable($model, $key);
            },
            ARRAY_FILTER_USE_KEY
        );
    }

    protected function filterWritable($model, $fields)
    {
        return array_filter(
            $fields,
            function ($key) use ($model) {
                return $this->getResolver()->isWritable($model, $key);
            },
            ARRAY_FILTER_USE_KEY
        );
    }

    protected function filterRelationReadable($model, $relations)
    {
        return array_filter(
            $relations,
            function ($key) use ($model, $relations) {
                return $this->getResolver()->isReadable($model, $key);
            },
            ARRAY_FILTER_USE_KEY
        );
    }

    protected function filterRelationWritable($model, $relations)
    {
        return array_filter(
            $relations,
            function ($key) use ($model, $relations) {
                return $this->getResolver()->isWritable($model, $key);
            },
            ARRAY_FILTER_USE_KEY
        );
    }
}