<?php
namespace Bagaaravel\Api\Transformers;

class GenericJsonApiTransformer extends Transformer implements TransformerInterface
{
    /**
     * @param $item
     * @return mixed
     */
    public function transformItem($item)
    {
        if (\Config::get('bagaaravel.timestamps_visible', false)) {
            $hidden = ['id', 'pivot'];
        } else {
            $hidden = ['id', 'created_at', 'updated_at', 'pivot'];
        }
        
        foreach( $this->relationships as $relationship => $model ){
            $hidden[] = $relationship;
            if ( method_exists($item, $relationship) ){
                if (method_exists($item->{$relationship}(), 'getForeignKeyName')) {
                    $hidden[] = $item->{$relationship}()->getForeignKeyName();
                } else if(method_exists($item->{$relationship}(), 'getQualifiedForeignKeyName'))  {
                    $hidden[] = $item->{$relationship}()->getQualifiedForeignKeyName();
                }
                else {
                    $hidden[] = $item->{$relationship}()->getQualifiedParentKeyName();
                }
            }
        }

        //check if item is polymorphic
        if ( method_exists($item, class_basename($item) . 'able') ){
            $basename = class_basename($item);
            $hidden[] = \Illuminate\Support\Str::snake($basename) . 'able_id';
            $hidden[] = \Illuminate\Support\Str::snake($basename) . 'able_type';
        }

        $item->makeHidden($hidden);
        $data = $item->toArray();

        return $this->transformAttributesByConfig($data);
    }
}